package com.ejie.aa94a.model.config;

import java.io.Serializable;
import java.util.List;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa94a.constantes.Constantes;

public class TipoSujecion implements Serializable, Cloneable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer codigo;
	private String tipo;
	private String descEs;
	private String descEu;
	private String imagenEs;
	private String imagenEu;

	private List<Solucion> soluciones;

	/**
	 * 
	 */
	public TipoSujecion() {
		super();
	}

	/**
	 * @param codigo
	 * @param tipo
	 * @param descEs
	 * @param descEu
	 * @param imagenEs
	 * @param imagenEu
	 */
	public TipoSujecion(Integer codigo, String tipo, String descEs,
			String descEu, String imagenEs, String imagenEu) {
		super();
		this.codigo = codigo;
		this.tipo = tipo;
		this.descEs = descEs;
		this.descEu = descEu;
		this.imagenEs = imagenEs;
		this.imagenEu = imagenEu;
	}

	/**
	 * Realiza copia del objeto.
	 */
	public Object clone() throws CloneNotSupportedException {
		Object obj = null;
		obj = super.clone();
		return obj;
	}

	/**
	 * @return the codigo
	 */
	public Integer getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(Integer codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the descEs
	 */
	public String getDescEs() {
		return descEs;
	}

	/**
	 * @param descEs
	 *            the descEs to set
	 */
	public void setDescEs(String descEs) {
		this.descEs = descEs;
	}

	/**
	 * @return the descEu
	 */
	public String getDescEu() {
		return descEu;
	}

	/**
	 * @param descEu
	 *            the descEu to set
	 */
	public void setDescEu(String descEu) {
		this.descEu = descEu;
	}

	/**
	 * @return the imagenEs
	 */
	public String getImagenEs() {
		return imagenEs;
	}

	/**
	 * @param imagenEs
	 *            the imagenEs to set
	 */
	public void setImagenEs(String imagenEs) {
		this.imagenEs = imagenEs;
	}

	/**
	 * @return the imagenEu
	 */
	public String getImagenEu() {
		return imagenEu;
	}

	/**
	 * @param imagenEu
	 *            the imagenEu to set
	 */
	public void setImagenEu(String imagenEu) {
		this.imagenEu = imagenEu;
	}

	/**
	 * @return the soluciones
	 */
	public List<Solucion> getSoluciones() {
		return soluciones;
	}

	/**
	 * @param soluciones
	 *            the soluciones to set
	 */
	public void setSoluciones(List<Solucion> soluciones) {
		this.soluciones = soluciones;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Method 'getDesc'.
	 * 
	 * @return String
	 */
	public String getDesc() {
		if (Constantes.EU.equalsIgnoreCase(LocaleContextHolder.getLocale()
				.getLanguage())) {
			return this.getDescEu();
		}
		return this.getDescEs();
	}

	/**
	 * Method 'getDesc'.
	 * 
	 * @return String
	 */
	public String getImagen() {
		if (Constantes.EU.equalsIgnoreCase(LocaleContextHolder.getLocale()
				.getLanguage())) {
			return this.getImagenEu();
		}
		return this.getImagenEs();
	}

}
